
-- fake infection level = symptoms of zombification
-- real infection level = zombification
local function createImmunity(player)
    local playerHP = player:getBodyDamage()
    local sicknessThreshold = 90

    -- start recovering from zombie sickness
    if playerHP:getFakeInfectionLevel() > sicknessThreshold then
        print('REDUCING SICKNESS')
        playerHP:setReduceFakeInfection(true)
    end

    if playerHP:IsInfected() then
        for i = 0, playerHP:getBodyParts():size() - 1 do
            local bodyPart = playerHP:getBodyParts():get(i)
            bodyPart:SetInfected(false)
        end
        playerHP:setInfected(false)
        playerHP:setInfectionLevel(0)

        -- make player think they have zombie sickess
        playerHP:setIsFakeInfected(true)
        print('INFECTION CURED')
    end
end

Events.OnPlayerUpdate.Add(createImmunity);
